/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.inferencing;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.PathUtil;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.AbstractRequireResolver;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodePackageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeModuleResolver
extends AbstractRequireResolver {
    private static final String LIB = "lib";
    private static final String NODE_MODULES = "node_modules";
    private static final String NODE = "node";
    private static final Set<String> CORE_MODULES = CollectionsUtil.newSet((Object[])new String[]{"_debugger", "_linklist", "assert", "buffer_ieee754", "buffer", "child_process", "cluster", "console", "constants", "crypto", "dgram", "dns", "domain", "events", "freelist", "fs", "http", "https", "module", "net", "os", "path", "punycode", "querystring", "readline", "repl", "stream", "string_decoder", "sys", "timers", "tls", "tty", "url", "util", "vm", "zlib"});
    private IPath location;

    @Override
    public IPath resolve(String moduleId, IProject project, IPath location, IPath indexRoot) {
        IPath relative;
        if (!location.toFile().isDirectory()) {
            throw new IllegalArgumentException("location must be a directory");
        }
        this.location = location;
        IPath result = null;
        if (this.isCore(moduleId)) {
            return this.coreModule(moduleId);
        }
        if ((moduleId.startsWith("./") || moduleId.startsWith("/") || moduleId.startsWith("../")) && (result = this.loadAsFile(relative = location.append(moduleId), NODE)) == null) {
            result = this.loadAsDirectory(relative, NODE);
        }
        if (result == null) {
            result = this.loadNodeModules(moduleId, location);
        }
        return result;
    }

    private IPath coreModule(String text) {
        IPath node = this.nodeSrcPath();
        if (node == null) {
            return null;
        }
        return node.append(LIB).append(text).addFileExtension("js");
    }

    protected synchronized IPath nodeSrcPath() {
        INodeJS nodeExecutable = JSCorePlugin.getDefault().getNodeJSService().getValidExecutable();
        if (nodeExecutable == null) {
            return null;
        }
        return nodeExecutable.getSourcePath();
    }

    private boolean isCore(String text) {
        Object[] files;
        IPath node = this.nodeSrcPath();
        if (node != null && !ArrayUtil.isEmpty((Object[])(files = node.append(LIB).toFile().list()))) {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (((String)file).equals(String.valueOf(text) + ".js")) {
                    return true;
                }
                ++n2;
            }
        }
        return CORE_MODULES.contains(text);
    }

    private IPath loadNodeModules(String x, IPath start) {
        List<IPath> dirs = this.nodeModulesPaths(start);
        for (IPath dir : dirs) {
            IPath path = this.loadAsFile(dir.append(x), NODE);
            if (path == null) {
                path = this.loadAsDirectory(dir.append(x), NODE);
            }
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private List<IPath> nodeModulesPaths(IPath start) {
        String[] parts = start.segments();
        int root = 0;
        int x = 0;
        while (x < parts.length) {
            if (NODE_MODULES.equals(parts[x])) {
                root = x;
                break;
            }
            ++x;
        }
        int i = parts.length - 1;
        ArrayList<IPath> dirs = new ArrayList<IPath>();
        while (i > root) {
            if (NODE_MODULES.equals(parts[i])) {
                --i;
                continue;
            }
            IPath dir = start.removeLastSegments(start.segmentCount() - i).append(NODE_MODULES);
            dirs.add(dir);
            --i;
        }
        dirs.addAll(this.globalFolders());
        return dirs;
    }

    private Collection<? extends IPath> globalFolders() {
        String home;
        ArrayList<IPath> dirs = new ArrayList<IPath>();
        Map env = ShellExecutable.getEnvironment((IPath)this.location);
        String nodePath = (String)env.get("NODE_PATH");
        if (nodePath != null) {
            String[] paths;
            String pathENV = PathUtil.convertPATH((String)nodePath);
            String[] stringArray = paths = pathENV.split(File.pathSeparator);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                dirs.add(Path.fromOSString((String)path));
                ++n2;
            }
        }
        if ((home = (String)env.get("HOME")) != null) {
            IPath homePath = Path.fromOSString((String)home);
            dirs.add(homePath.append(".node_modules"));
            dirs.add(homePath.append(".node_libraries"));
        }
        try {
            IPath modulesPath = this.getModulesPath();
            if (modulesPath != null) {
                dirs.add(modulesPath);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
        }
        return dirs;
    }

    protected synchronized IPath getModulesPath() throws CoreException {
        INodePackageManager npm = JSCorePlugin.getDefault().getNodePackageManager();
        if (npm == null) {
            return null;
        }
        return npm.getModulesPath();
    }

    @Override
    public boolean applies(IProject project, IPath currentDirectory, IPath indexRoot) {
        return true;
    }

    @Override
    public List<String> getPossibleModuleIds(IProject project, IPath currentDirectory, IPath indexRoot) {
        Object[] files;
        HashSet<Object> moduleIds = new HashSet<Object>();
        IPath node = this.nodeSrcPath();
        if (node != null && !ArrayUtil.isEmpty((Object[])(files = node.append(LIB).toFile().list()))) {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (((String)file).endsWith(".js")) {
                    file = ((String)file).substring(0, ((String)file).length() - 3);
                }
                moduleIds.add(file);
                ++n2;
            }
        }
        moduleIds.addAll(CORE_MODULES);
        return new ArrayList<String>(moduleIds);
    }
}

